import os
import subprocess
from tkinter import Tk, filedialog

def select_directory():
    root = Tk()
    root.withdraw()  # Verstecke das Hauptfenster
    folder_selected = filedialog.askdirectory()
    return folder_selected

def get_exif_data(file_path, parameters):
    # Kompilieren der exiftool-Befehlszeile
    command = ['exiftool']
    command.extend(parameters)
    command.append(file_path)
    
    result = subprocess.run(command, capture_output=True, text=True)
    return result.stdout

def main():
    print("Bitte wählen Sie ein Verzeichnis aus:")
    directory = select_directory()
    if not directory:
        print("Kein Verzeichnis ausgewählt. Beende das Programm.")
        return

    # Definieren der EXIF-Parameter direkt im Skript
    parameters = [
        '-EXIF:model',
        '-EXIF:lensmodel',
        '-EXIF:focallength',
        '-EXIF:FNumber',
        '-MakerNotes:focusdistance',
        '-MakerNotes:focusbracketstepsize',
        '-Composite:DOF',
        '-MakerNotes:drivemode',
        '-MakerNotes:stackedimage',
        '-MakerNotes:artfilter'
    ]

    exif_data_list = []
    for filename in sorted(os.listdir(directory)):
        if filename.lower().endswith(('.jpg', '.jpeg', '.png', '.tiff', '.orf', '.ori')):
            file_path = os.path.join(directory, filename)
            exif_data = get_exif_data(file_path, parameters)
            exif_data_list.append(f"Dateiname: {filename}\n{exif_data}")

    # Speichern der Ergebnisse in einer Datei im ausgewählten Verzeichnis
    output_file_path = os.path.join(directory, 'exiftool_script_data.txt')
    with open(output_file_path, 'w') as output_file:
        output_file.write("\n".join(exif_data_list))

    print(f"EXIF-Daten wurden erfolgreich ausgelesen und in {output_file_path} gespeichert.")

if __name__ == "__main__":
    main()
