import os
import subprocess
from tkinter import Tk, filedialog

def select_directory():
    root = Tk()
    root.withdraw()
    folder_selected = filedialog.askdirectory()
    return folder_selected

def main():
    print("Please select a directory:")
    directory = select_directory()
    if not directory:
        print("No directory selected. Exiting the program.")
        return

    # Define the file extensions to include
    valid_extensions = ('.jpg', '.jpeg', '.png', '.tiff', '.orf', '.ori')

    # List to hold the file paths of valid photo files
    photo_files = [
        f for f in os.listdir(directory)
        if f.lower().endswith(valid_extensions)
    ]

    if not photo_files:
        print("No valid photo files found in the selected directory.")
        return

    # Define EXIF parameters directly in the script
    parameters = [
        'EXIF:Model',
        'EXIF:LensModel',
        'EXIF:FocalLength',
        'EXIF:FNumber',
        'MakerNotes:FocusDistance',
        'MakerNotes:FocusBracketStepSize',
        'Composite:DOF',
        'MakerNotes:DriveMode',
        'MakerNotes:StackedImage',
        'MakerNotes:ArtFilter'
    ]

    # Prepare the exiftool command
    command = ['exiftool', '-csv']
    command.extend([f'-{param}' for param in parameters])
    command.extend([os.path.join(directory, f) for f in photo_files])
    
    # Define the output CSV file path
    output_file_path = os.path.join(directory, 'exiftool_script_data.csv')

    # Run the exiftool command and capture the output
    with open(output_file_path, 'w') as output_file:
        subprocess.run(command, stdout=output_file)

    # Read the generated CSV and replace the file paths with filenames
    import pandas as pd
    df = pd.read_csv(output_file_path)
    df['SourceFile'] = df['SourceFile'].apply(os.path.basename)
    df.to_csv(output_file_path, index=False)

    print(f"EXIF data successfully extracted and saved to {output_file_path}.")

if __name__ == "__main__":
    main()
