import requests
import time

CAMERA_IP = "192.168.0.10"
BASE_URL = f"http://{CAMERA_IP}"
MODE_SWITCH_WAIT = 2  # Sekunden warten nach Moduswechsel

def set_rec_mode():
    url = f"{BASE_URL}/switch_cammode.cgi"
    params = {"mode": "rec"}
    try:
        r = requests.get(url, params=params, timeout=5)
        time.sleep(MODE_SWITCH_WAIT)
        print("Kamera im REC-Modus")
    except Exception as e:
        print("Fehler beim Moduswechsel:", e)

def set_property(propname, value):
    url = f"{BASE_URL}/set_camprop.cgi?com=set&propname={propname}"
    xml_body = f"<set><value>{value}</value></set>"
    headers = {"Content-Type": "application/xml"}
    try:
        r = requests.post(url, data=xml_body, headers=headers, timeout=5)
        print(f"{propname} gesetzt auf {value}")
    except Exception as e:
        print(f"Fehler beim Setzen von {propname}:", e)

def parse_shutter_input(s):
    """
    Intuitive Umwandlung von Belichtungszeit:
    - 1/125 -> 125
    - 0.5   -> 2 (0.5 Sek)
    - 2     -> 2 Sek
    - 125   -> 125 (1/125 Sek)
    """
    s = s.strip().replace(",", ".")
    if "/" in s:
        num, den = s.split("/")
        return int(den)
    try:
        val = float(s)
        if val >= 1:
            # Ganze Zahl: kleine Werte (<10) = Sekunden, große Werte (>10) = 1/val
            if val > 10:
                return int(round(val))  # 125 -> 125
            else:
                return int(round(val))  # 2 -> 2 Sek
        else:
            # Dezimal <1 Sekunde
            return int(round(1 / val))
    except:
        print("Belichtungszeit konnte nicht interpretiert werden. Bitte 1/125, 0.5, 2 etc. eingeben.")
        return None

def main():
    print("OM-1 Mark II Kamera Steuerung\n")

    set_rec_mode()

    # Eingaben
    shutter_input = input("Belichtungszeit (z.B. 1/125, 0.5, 2, 125): ")
    aperture_input = input("Blende (z.B. 2.8, 4, 5.6, 8): ")
    iso_input = input("ISO (z.B. 200, 400, 800): ")

    # Belichtungszeit
    if shutter_input.strip():
        shut_value = parse_shutter_input(shutter_input)
        if shut_value:
            set_property("shutspeedvalue", shut_value)

    # Blende direkt
    if aperture_input.strip():
        set_property("focalvalue", aperture_input.strip())

    # ISO direkt
    if iso_input.strip():
        set_property("isospeedvalue", iso_input.strip())

    print("\nFertig.")

if __name__ == "__main__":
    main()
